<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require 'db.php';

$data = json_decode(file_get_contents("php://input"));

// Validasi input dari AutoResponder
if (empty($data) || empty($data->query) || empty($data->query->message)) {
    http_response_code(400);
    echo json_encode([
        "replies" => [
            ["message" => "❌ Permintaan tidak valid."]
        ]
    ]);
    exit;
}

// Pastikan pesan yang dikirim user adalah 'total' (case insensitive)
$message = strtolower(trim($data->query->message));
if ($message !== 'total') {
    echo json_encode(["replies" => []]);
    exit;
}

try {
    // Ambil total semua player
    $stmt = $pdo->query("SELECT COUNT(*) AS total FROM players");
    $totalPlayers = (int) $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Daftar role utama yang ingin dicek
    $roles = ['jungler', 'gold', 'exp', 'mid', 'roam'];

    $counts = [];
    foreach ($roles as $role) {
        $stmt = $pdo->prepare("SELECT COUNT(*) AS total FROM players WHERE LOWER(role_utama) = ?");
        $stmt->execute([strtolower($role)]);
        $counts[$role] = (int) $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    }

    // Siapkan message balasan
    $replyMessage = "📊 Statistik Player:\n\n";
    $replyMessage .= "Total player: $totalPlayers\n";
    foreach ($roles as $role) {
        $roleName = ucfirst($role);
        $replyMessage .= "Total $roleName: " . $counts[$role] . "\n";
    }

    echo json_encode([
        "replies" => [
            ["message" => $replyMessage]
        ]
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "replies" => [
            ["message" => "⚠️ Terjadi kesalahan server."]
        ]
    ]);
}
