<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->query->message) && !empty($data->query->sender)) {
    require 'db.php';

    $message = strtolower(trim($data->query->message));
    $reply = "⚠️ Format salah. Gunakan:\n• cek wa 08xxxxxxxxxx\n• cek id your_id\n• cek role role_utama";

    // Function to normalize WA number
    function normalize_wa($nomor) {
        $nomor = preg_replace('/[^0-9+]/', '', $nomor);
        if (strpos($nomor, '+62') === 0) {
            $nomor = '0' . substr($nomor, 3);
        }
        return $nomor;
    }

    // Function to format player data with role icons
    function formatPlayer($row) {
        $roleIcons = [
            'Jungler' => '🍃️', 
            'Gold' => '🪙', 
            'EXP' => '🗡️', 
            'Roam' => '🛡️', 
            'Mid' => '🔮'
        ];

        $roleUtamaIcon = isset($roleIcons[$row['role_utama']]) ? $roleIcons[$row['role_utama']] : '❓';
        $roleCadanganIcon = isset($roleIcons[$row['role_cadangan']]) ? $roleIcons[$row['role_cadangan']] : '❓';

        return
            "• Nomor WA    : " . $row['nomor_wa'] . "\n" . 
            "• Nick       : " . $row['username_ml'] . "\n" . 
            "• ID ML      : " . $row['id_ml'] . "\n" . 
            "• Role Utama : " . $roleUtamaIcon . " " . $row['role_utama'] . "\n" . 
            "• Role Cadangan: " . $roleCadanganIcon . " " . $row['role_cadangan'] . "\n";
    }

    // Handling the different message formats
    if (preg_match('/^cek wa\s+(.+)$/i', $message, $matches)) {
        $rawNomor = $matches[1];
        $nomor = normalize_wa($rawNomor);

        $stmt = $pdo->prepare("SELECT * FROM players WHERE nomor_wa = ?");
        $stmt->execute([$nomor]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $reply = "✅ Data ditemukan:\n" . formatPlayer($row);
        } else {
            $reply = "❌ Nomor WA $nomor belum terdaftar.";
        }
    } elseif (preg_match('/^cek id\s+(.+)$/i', $message, $matches)) {
        $id_ml = trim($matches[1]);

        $stmt = $pdo->prepare("SELECT * FROM players WHERE id_ml = ?");
        $stmt->execute([$id_ml]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $reply = "✅ Data ditemukan:\n" . formatPlayer($row);
        } else {
            $reply = "❌ ID ML $id_ml belum terdaftar.";
        }
    } elseif (preg_match('/^cek role\s+(.+)$/i', $message, $matches)) {
        $role = trim($matches[1]);

        // Check only for primary role
        $stmt = $pdo->prepare("SELECT nomor_wa, username_ml, id_ml, role_utama, role_cadangan FROM players WHERE LOWER(role_utama) = LOWER(?)");
        $stmt->execute([$role]);
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($rows && count($rows) > 0) {
            $count = count($rows);
            $reply = "✅ Ditemukan $count pemain dengan role utama \"$role\":\n\n";
            foreach ($rows as $r) {
                $reply .= formatPlayer($r) . "\n";
            }
            $reply .= "\nTotal pemain: $count";
        } else {
            $reply = "❌ Tidak ditemukan pemain dengan role utama \"$role\".";
        }
    }

    // Return response
    echo json_encode([
        "replies" => [
            ["message" => $reply]
        ]
    ], JSON_UNESCAPED_UNICODE);

} else {
    http_response_code(400);
    echo json_encode([
        "replies" => [
            ["message" => "⚠️ Permintaan tidak valid. Gunakan format:\n• cek wa 08xxxxxxxxxx\n• cek id your_id\n• cek role role_utama"]
        ]
    ]);
}
