<?php
// Koneksi ke database
include 'db.php';

// Ambil parameter pencarian dari URL
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Fungsi untuk menampilkan icon sesuai role
function roleWithIcon($role) {
    $roleLower = strtolower($role);
    switch ($roleLower) {
        case 'jungler':
            $icon = '<i class="fas fa-leaf text-success"></i>';
            break;
        case 'gold':
            $icon = '<i class="fas fa-coins text-warning"></i>';
            break;
        case 'exp':
            $icon = '<i class="fas fa-bolt text-danger"></i>';
            break;
        case 'mid':
            $icon = '<i class="fas fa-star text-primary"></i>';
            break;
        case 'roam':
            $icon = '<i class="fas fa-shield-alt text-info"></i>';
            break;
        default:
            $icon = '<i class="fas fa-question-circle text-secondary"></i>';
            break;
    }
    return $icon . ' ' . htmlspecialchars(ucfirst($role));
}

// Query ke database dengan prepared statement untuk keamanan
$query = "SELECT username_ml, rank_saat_ini, high_rank, role_utama, role_cadangan, nomor_wa
          FROM players
          WHERE username_ml LIKE :search OR rank_saat_ini LIKE :search OR high_rank LIKE :search
          OR role_utama LIKE :search OR role_cadangan LIKE :search OR nomor_wa LIKE :search";

$stmt_players = $pdo->prepare($query);
$stmt_players->execute(['search' => "%$search%"]);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Daftar Pemain Terdaftar - Skyzo eSports</title>

    <link rel="icon" href="https://skyzo.alfagmr.my.id/skyzo.png" type="image/png" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet" />

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

    <!-- Font Awesome -->
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
    />

    <style>
        /* Body background biru gelap dan teks putih */
        body {
            background-color: #0d1b2a; /* biru gelap */
            color: #ffffff;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }

        /* Header card */
        .card-header {
            background-color: #1b263b; /* warna biru gelap lebih terang */
            color: white;
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 600;
            font-size: 1.25rem;
        }

        .card-header img {
            max-width: 50px;
            height: auto;
        }

        /* Table Header */
        table.dataTable thead th {
            background: #1b263b; /* header tabel warna biru gelap */
            color: #ffffff;
            border-bottom: none;
        }

        /* Table Body Rows */
        table.dataTable tbody tr {
            background-color: #ffffff;
            color: #111111;
        }

        /* Hover effect on rows */
        table.dataTable tbody tr:hover {
            background-color: #a9d6e5; /* hover biru muda */
            color: #0d1b2a;
        }

        /* Table borders */
        table.dataTable,
        table.dataTable th,
        table.dataTable td {
            border: 1px solid #1b263b;
        }

        /* Pagination buttons */
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            color: #1b263b !important;
            background-color: #ffffff !important;
            border: 1px solid #1b263b !important;
            border-radius: 4px;
            margin: 0 2px;
            padding: 3px 10px;
            cursor: pointer;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button.current {
            background-color: #1b263b !important;
            color: #ffffff !important;
            font-weight: bold;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
            background-color: #3a5a81 !important;
            color: #ffffff !important;
        }

        /* Filter input & length select */
        .dataTables_wrapper .dataTables_filter input,
        .dataTables_wrapper .dataTables_length select {
            background-color: #ffffff;
            color: #111111;
            border: 1px solid #1b263b;
            border-radius: 4px;
            padding: 4px 8px;
        }

        /* Labels for filter and length */
        .dataTables_wrapper .dataTables_filter label,
        .dataTables_wrapper .dataTables_length label {
            color: #ffffff;
            font-weight: 600;
        }

        /* Info text */
        .dataTables_wrapper .dataTables_info {
            color: #ffffff;
            margin-top: 10px;
        }

        /* WhatsApp button */
        .btn-outline-success {
            color: #1b263b;
            border-color: #1b263b;
            font-weight: 600;
        }

        .btn-outline-success:hover {
            background-color: #1b263b;
            color: #ffffff;
            border-color: #133152;
        }

        /* Tombol kembali */
        .btn-outline-dark {
            color: #1b263b;
            border-color: #1b263b;
            font-weight: 600;
        }

        .btn-outline-dark:hover {
            background-color: #1b263b;
            color: #ffffff;
            border-color: #133152;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header">
            <img src="https://skyzo.alfagmr.my.id/skyzo.png" alt="Skyzo eSports" />
            Daftar Pemain Terdaftar - Skyzo eSports
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="playersTable" style="width:100%">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Username ML</th>
                            <th>Rank Saat Ini</th>
                            <th>Rank Tertinggi</th>
                            <th>Role Utama</th>
                            <th>Role Cadangan</th>
                            <th>Nomor WA</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($stmt_players && $stmt_players->rowCount() > 0): ?>
                            <?php $no = 1; while ($row = $stmt_players->fetch(PDO::FETCH_ASSOC)): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($row['username_ml']) ?></td>
                                    <td><?= htmlspecialchars($row['rank_saat_ini']) ?></td>
                                    <td><?= htmlspecialchars($row['high_rank']) ?></td>
                                    <td><?= roleWithIcon($row['role_utama']) ?></td>
                                    <td><?= roleWithIcon($row['role_cadangan']) ?></td>
                                    <td>
                                        <?php
                                            $wa_number = preg_replace('/[^0-9]/', '', $row['nomor_wa']);
                                            if (str_starts_with($wa_number, '62')) {
                                                $wa_number = '0' . substr($wa_number, 2);
                                            }
                                        ?>
                                        <a href="https://wa.me/<?= preg_replace('/^0/', '62', $wa_number) ?>" target="_blank" class="btn btn-outline-success btn-sm">
                                            <i class="fab fa-whatsapp"></i> Hubungi
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">Belum ada pemain terdaftar.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <button type="button" class="btn btn-outline-dark w-100 mt-3" onclick="window.location.href='index.php'">
                Kembali ke Halaman Utama
            </button>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(document).ready(function () {
    $('#playersTable').DataTable({
        responsive: true,
        ordering: true,
        paging: true,
        searching: true,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Semua"]],
        pageLength: 10,
        language: {
            search: "Cari:",
            lengthMenu: "Tampilkan _MENU_ entri",
            info: "Menampilkan _START_ hingga _END_ dari _TOTAL_ entri",
            infoEmpty: "Tidak ada data tersedia",
            zeroRecords: "Tidak ditemukan data yang cocok",
            paginate: {
                next: "Berikutnya",
                previous: "Sebelumnya"
            }
        }
    });
});
</script>

</body>
</html>
