<?php
session_start();
require 'db.php'; // pastikan $pdo sudah terkoneksi

// Ambil data form dan pesan dari session jika ada
$form_data = $_SESSION['form_data'] ?? [];
$error = $_SESSION['error'] ?? '';
$success = $_SESSION['success'] ?? '';

// Jika sukses, kosongkan form
if ($success) {
    $form_data = [];
}

// Hitung jumlah pemain
$stmt = $pdo->query("SELECT COUNT(*) FROM players");
$totalPlayers = $stmt->fetchColumn();

// Bersihkan session sementara
unset($_SESSION['error'], $_SESSION['success'], $_SESSION['form_data']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Skyzo eSports - Rekrutmen Pemain</title>
  <link rel="icon" href="https://skyzo.alfagmr.my.id/skyzo.png" type="image/png" />

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet" />

  <!-- Toastify -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css" />

  <style>
    body {
      font-family: 'Inter', sans-serif;
      background-color: #0f172a;
      color: white;
      margin: 0;
      padding: 0;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
    }
    .hero {
      max-width: 600px;
      width: 100%;
      padding: 40px 20px;
      text-align: center;
    }
    .hero img {
      max-width: 180px;
      margin-bottom: 24px;
    }
    .hero h1 {
      font-size: 2.5rem;
      font-weight: 700;
      margin-bottom: 16px;
      line-height: 1.2;
    }
    .hero p {
      font-size: 1.25rem;
      margin-bottom: 32px;
      color: #cbd5e1;
    }
    .hero a {
      display: inline-block;
      background-color: #22c55e;
      color: white;
      padding: 14px 28px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 1rem;
      text-decoration: none;
      margin: 0 8px 12px;
      transition: background-color 0.3s ease;
      cursor: pointer;
    }
    .hero a:hover,
    .hero a:focus {
      background-color: #16a34a;
      text-decoration: none;
      outline: none;
    }

    /* Tombol Login Admin */
    .login-btn {
      position: absolute;
      top: 20px;
      right: 20px;
    }
    .login-btn a {
      background-color: #1d4ed8;
      color: white;
      padding: 10px 20px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 0.9rem;
      text-decoration: none;
      transition: background-color 0.3s ease;
    }
    .login-btn a:hover {
      background-color: #1e40af;
    }

    /* Responsive */
    @media (max-width: 480px) {
      .hero h1 {
        font-size: 1.75rem;
      }
      .hero p {
        font-size: 1rem;
      }
      .hero a {
        padding: 12px 20px;
        font-size: 0.9rem;
      }
    }
  </style>
</head>
<body>
 <!-- Menampilkan pesan error jika ada -->
    <?php if (isset($_SESSION['error'])): ?>
        <div class="error" style="color: red;">
            <?php echo $_SESSION['error']; ?>
            <?php unset($_SESSION['error']); ?>
        </div>
    <?php endif; ?>

    <!-- Menampilkan pesan sukses jika ada -->
    <?php if (isset($_SESSION['success'])): ?>
        <div class="success" style="color: green;">
            <?php echo $_SESSION['success']; ?>
            <?php unset($_SESSION['success']); ?>
        </div>
    <?php endif; ?>
  <!-- Tombol Login Admin -->
  <div class="login-btn">
    <a href="admin/login.php">Login Admin</a>
  </div>

  <div class="hero">
    <img src="https://skyzo.alfagmr.my.id/skyzo.png" alt="Skyzo Logo" />
    <h1>Rekrutmen Pemain Skyzo E-Sports<br />Saatnya Tunjukkan Kemampuanmu!</h1>
    <p>Bergabunglah dengan kami dan buktikan bahwa kamu layak menjadi juara!</p>
    <a href="form.php" role="button">Daftar Sekarang</a>
    <a href="list.php" role="button">Roster Terdaftar (<?= number_format($totalPlayers) ?>)</a>
  </div>

  <!-- Toastify -->
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

  <?php if ($success): ?>
  <script>
    Toastify({
      text: <?= json_encode($success) ?>,
      duration: 5000,
      gravity: "top",
      position: "right",
      backgroundColor: "green",
    }).showToast();
  </script>
  <?php endif; ?>

  <?php if ($error): ?>
  <script>
    Toastify({
      text: <?= json_encode($error) ?>,
      duration: 5000,
      gravity: "top",
      position: "right",
      backgroundColor: "red",
    }).showToast();
  </script>
  <?php endif; ?>

</body>
</html>
