<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit("Method not allowed");
}

require 'db.php';

function sanitize($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

$nomor_wa = sanitize($_POST['nomor_wa'] ?? '');
$nama = sanitize($_POST['nama'] ?? '');
$username = sanitize($_POST['username'] ?? '');
$id_ml = sanitize($_POST['id_ml'] ?? '');
$rank_sekarang = sanitize($_POST['rank_sekarang'] ?? '');
$rank_tertinggi = intval($_POST['rank_tertinggi'] ?? 0);
$role_utama = sanitize($_POST['role_utama'] ?? '');
$role_cadangan = sanitize($_POST['role_cadangan'] ?? '');
$hero = sanitize($_POST['hero'] ?? '');
$aktif = sanitize($_POST['aktif'] ?? '');
$turnamen = sanitize($_POST['turnamen'] ?? '');
$alasan = sanitize($_POST['alasan'] ?? '');

$required_fields = [$nomor_wa, $nama, $username, $id_ml, $rank_sekarang, $rank_tertinggi, $role_utama, $hero, $aktif, $turnamen, $alasan];
if (in_array('', $required_fields, true)) {
    $_SESSION['error'] = "Semua kolom wajib diisi.";
    header("Location: index.php");
    exit();
}

if ($rank_tertinggi < 100) {
    $_SESSION['error'] = "Rank tertinggi minimal harus Mythic Immortal 100.";
    header("Location: index.php");
    exit();
}

$stmt = $pdo->prepare("SELECT * FROM players WHERE nomor_wa = ? OR username_ml = ? OR id_ml = ?");
$stmt->execute([$nomor_wa, $username, $id_ml]);
$existing_user = $stmt->fetch();

if ($existing_user) {
    $errors = [];
    if ($existing_user['nomor_wa'] == $nomor_wa) {
        $errors[] = "Nomor WA '$nomor_wa' sudah terdaftar.";
    }
    if ($existing_user['username_ml'] == $username) {
        $errors[] = "Username '$username' sudah terdaftar.";
    }
    if ($existing_user['id_ml'] == $id_ml) {
        $errors[] = "ID ML '$id_ml' sudah terdaftar.";
    }

    $_SESSION['error'] = implode(' ', $errors);
    header("Location: index.php");
    exit();
}

$stmt = $pdo->prepare("INSERT INTO players 
    (nomor_wa, nama_lengkap, username_ml, id_ml, rank_saat_ini, high_rank, role_utama, role_cadangan, hero_dikuasai, aktif_harian, siap_turnamen, alasan, created_at)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

$success = $stmt->execute([
    $nomor_wa,
    $nama,
    $username,
    $id_ml,
    $rank_sekarang,
    $rank_tertinggi,
    $role_utama,
    $role_cadangan,
    $hero,
    $aktif,
    $turnamen,
    $alasan
]);

if ($success) {
    $_SESSION['success'] = "Pendaftaran berhasil! Kami akan menghubungi Anda.";
} else {
    $_SESSION['error'] = "Terjadi kesalahan saat menyimpan data.";
}

header("Location: index.php");
exit();
?>