<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->query->message) && !empty($data->query->sender)) {
    require 'db.php';

    $message = strtolower(trim($data->query->message));
    $reply = "⚠️ Format salah. Gunakan: cek hasil";

    // Jika perintah adalah "cek hasil"
    if (preg_match('/cek hasil/i', $message)) {
        // Ambil data semua pemain
        $stmt = $pdo->prepare("SELECT * FROM players");
        $stmt->execute();
        $players = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Inisialisasi kategori hasil
        $lolos = [];
        $proses = [];
        $gagal = [];

        // Kategorikan pemain berdasarkan status trial
        foreach ($players as $row) {
            $status = $row['lolos_trial'];
            $playerData = "• Nomor WA: " . $row['nomor_wa'] . "\n"
                        . "• Nama: " . $row['nama_lengkap'] . " (" . $row['username_ml'] . ")";

            if ($status == 1) {
                $lolos[] = $playerData;
            } elseif ($status == 2) {
                $gagal[] = $playerData;
            } else {
                $proses[] = $playerData;
            }
        }

        // Bangun balasan yang terstruktur
        $reply = "📋 Hasil Trial:\n\n";

        if (!empty($lolos)) {
            $reply .= "✅ **Lolos**:\n" . implode("\n", $lolos) . "\n";
        }

        if (!empty($proses)) {
            $reply .= "⏳ **Proses Trial**:\n" . implode("\n", $proses) . "\n";
        }

        if (!empty($gagal)) {
            $reply .= "❌ **Tidak Lolos**:\n" . implode("\n", $gagal) . "\n";
        }
    }

    echo json_encode([
        "replies" => [
            ["message" => $reply]
        ]
    ], JSON_UNESCAPED_UNICODE);
} else {
    http_response_code(400);
    echo json_encode([
        "replies" => [
            ["message" => "⚠️ Permintaan tidak valid. Gunakan format: cek hasil"]
        ]
    ]);
}
