Code saya gini,,,

"<?php header("Access-Control-Allow-Origin: *"); header("Content-Type: application/json; charset=UTF-8");

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->query->message) && !empty($data->query->sender)) { require 'db.php';

$message = strtolower(trim($data->query->message));
$reply = "⚠️ Format salah. Gunakan:\n• roaster hari ini";

if ($message == 'roaster hari ini') {
    $roles = ['jungler', 'gold', 'exp', 'roam', 'mid'];  // Mengganti 'xp' menjadi 'exp'
    $players = [];

    // Ambil 5 pemain untuk setiap role dari database
    foreach ($roles as $role) {
        $stmt = $pdo->prepare("SELECT * FROM players WHERE role_utama = ? LIMIT 1");
        $stmt->execute([$role]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            // Menyimpan data pemain untuk setiap role
            $players[$role] = [
                'username' => $row['username_ml'],
                'nama_lengkap' => $row['nama_lengkap'],
                'role_utama' => $row['role_utama'],
                'nomor_wa' => normalize_wa($row['nomor_wa'])  // Menggunakan fungsi normalize WA
            ];
        } else {
            $players[$role] = null;
        }
    }

    // Fungsi untuk normalisasi nomor WA
    function normalize_wa($nomor) {
        $nomor = preg_replace('/[^0-9+]/', '', $nomor);
        if (strpos($nomor, '+62') === 0) {
            $nomor = '0' . substr($nomor, 3);
        }
        return $nomor;
    }

    // Shuffle players untuk mengacak posisi mereka
    shuffle($players);

    // Menambahkan emoji dan mencetak reply
    $reply = "🔄 **Roaster Hari Ini**:\n";
    $counter = 1;
    $roleEmojis = [
        'jungler' => '🐆 Jungler',
        'gold' => '💰 Gold',
        'exp' => '⚡ EXP',  // Mengganti 'xp' menjadi 'exp'
        'roam' => '🌍 Roam',
        'mid' => '🔥 Mid'
    ];

    foreach ($players as $role => $player) {
        if ($player) {
            $emoji = $roleEmojis[$role] ?? '🎮 Role';
            $reply .= "$counter. $emoji - " . $player['username'] . " (" . $player['nama_lengkap'] . ")\n";
            $reply .= "  • Nomor WA: " . $player['nomor_wa'] . "\n\n";
        } else {
            $reply .= "$counter. $role - Tidak Ada Pemain\n\n";
        }
        $counter++;
    }
}

echo json_encode([
    "replies" => [
        ["message" => $reply]
    ]
], JSON_UNESCAPED_UNICODE);

} else { http_response_code(400); echo json_encode([ "replies" => [ ["message" => "⚠️ Permintaan tidak valid. Gunakan format:\n• roaster hari ini"] ] ]); } "

Bisa buatkan saya code baru dengan perintah baru juga

Roaster hari ini

Nanti akan menampilkan 5 roaster secara acak tetapi sesuai role yang dipilih seperti jungler, roam, mid, exp, gold...

