# Capturing QR Code

An event is emitted every time the QR code is received by the system. You can grab hold of this event emitter by importing [`ev`](/TODO). You can capture this qr code and save it to a file.

```javascript
import { ev } from '@open-wa/wa-automate';
const fs = require('fs');

ev.on('qr.**', async qrcode => {
  //qrcode is base64 encoded qr code image
  //now you can do whatever you want with it
  const imageBuffer = Buffer.from(
    qrcode.replace('data:image/png;base64,', ''),
    'base64'
  );
  fs.writeFileSync('qr_code.png', imageBuffer);
});
```
